namespace Hive.Unity.Editor
{
    using System.Collections.Generic;
    using System.IO;
    using System.Xml;
    using System.ComponentModel;
    #if UNITY_EDITOR
    using UnityEditor;
    #endif
    using UnityEngine;

    public abstract class HiveStep
    {
        internal HiveGUI gui;
        internal Rect rect;
        internal abstract HiveConfigStep currentStep { get; }
        internal HiveStep(Rect position)
        {
            this.rect = position;
            this.gui = new HiveGUI(position.width);
        }

        internal abstract void titleArea();
        internal abstract void selectPlatformArea();
        internal abstract void contentsArea();
        internal abstract void buttonsArea();

        internal virtual HiveConfigStep dropdownMenu()
        {
            HiveConfigStep step;

            EditorGUILayout.BeginHorizontal();
            step = (HiveConfigStep)EditorGUILayout.EnumPopup("", currentStep);
            GUILayout.FlexibleSpace();
            EditorGUILayout.EndHorizontal();
            
            return step;
        }
    }

}